// kbmucom.cpp : DLL AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "kbmucom.h"
#include "kmp_pi.h"
#include "musiccom.h"

using namespace std;
using namespace boost;

HMODULE hKbMucomModule;

#define KMPPLUGIN_VERSION     1
#define KMPPLUGIN_COPYRIGHT	  "Copyright (C) 2007 asmichi, cisc"
#define KMPPLUGIN_DESCRIPTION "ASCII music.com MML player (powered by cisc's fmgen library)"

class KbMucom
{
public:
	KbMucom();
	BOOL	Open(const char *cszFileName, SOUNDINFO *pInfo);
	DWORD	Render(BYTE *pBuffer, DWORD dwSize);
	DWORD	SetPosition(DWORD dwPos);
	~KbMucom();
private:
	MusicCom::MusicCom mucom;
	uint	bytespersample;
	SOUNDINFO info;
};

KbMucom::KbMucom()
{
	int fmvol = 0, psgvol = 0;
	try {
		char iniName[MAX_PATH];
		GetModuleFileName(hKbMucomModule, iniName, sizeof(iniName));
		PathRemoveExtension(iniName);
		PathAddExtension(iniName, ".ini");

		char buf[256];
		GetPrivateProfileString("kbmucom", "FMVolume", "0", buf, sizeof(buf), iniName);
		fmvol = boost::lexical_cast<int>(buf);
		GetPrivateProfileString("kbmucom", "PSGVolume", "0", buf, sizeof(buf), iniName);
		psgvol = boost::lexical_cast<int>(buf);
	}
	catch (boost::bad_lexical_cast) {
	}
	mucom.SetFMVolume(fmvol);
	mucom.SetPSGVolume(psgvol);
}

KbMucom::~KbMucom()
{
}

BOOL KbMucom::Open(const char *cszFileName, SOUNDINFO *pInfo)
{
	if (pInfo == NULL){
		return FALSE;
	}

	if (pInfo->dwSamplesPerSec == 0) {
		pInfo->dwSamplesPerSec = 44100;
	}
	pInfo->dwBitsPerSample = 16;
	pInfo->dwLength = 0xFFFFFFFF;
	pInfo->dwChannels = 2;
	pInfo->dwSeekable = 0;
	pInfo->dwUnitRender = 0;
	pInfo->dwReserved1 = 0xFFFFFFFF;
	pInfo->dwReserved2 = 0;

	if (!mucom.Load(cszFileName))
		return FALSE;
	if (!mucom.PrepareMix(pInfo->dwSamplesPerSec))
		return FALSE;

	bytespersample = pInfo->dwChannels * pInfo->dwBitsPerSample/8;
	info = *pInfo;
	return TRUE;
}

DWORD KbMucom::Render(BYTE *Buffer, DWORD dwSize)
{
	mucom.Mix((int16 *)Buffer, dwSize/bytespersample);
	return dwSize;
}

DWORD KbMucom::SetPosition(DWORD dwPos)
{
	mucom.PrepareMix(info.dwSamplesPerSec);
	return 0;
}

static HKMP WINAPI kmp_Open(const char *cszFileName, SOUNDINFO *pInfo)
{
	OutputDebugString(cszFileName);

	KbMucom *pMucom = new KbMucom;
	if (pMucom->Open(cszFileName, pInfo)){
		return (HKMP)pMucom;
	}
	else {
		delete pMucom;
		return NULL;
	}
}

static void WINAPI kmp_Close(HKMP hKMP)
{
	KbMucom *pMucom = (KbMucom*)hKMP;
	delete pMucom;
}

static DWORD WINAPI kmp_Render(HKMP hKMP, BYTE *Buffer, DWORD dwSize)
{
	KbMucom *pMucom = (KbMucom*)hKMP;
	if (pMucom){
		return pMucom->Render(Buffer, dwSize);
	}
	else {
		return 0;
	}
}


static DWORD WINAPI kmp_SetPosition(HKMP hKMP, DWORD dwPos)
{
	KbMucom *pMucom = (KbMucom*)hKMP;
	if (pMucom){
		return pMucom->SetPosition(dwPos);
	}
	else {
		return 0;
	}
}

KMPMODULE* WINAPI kmp_GetTestModule()
{
	static const char *ppszSupportExts[] = {".mml", ".mucom", NULL};	//  .mucom ǉ

	static KMPMODULE Mod = 
	{
		KMPMODULE_VERSION,		// dwVersion 
		KMPPLUGIN_VERSION,		// dwPluginVersion
		KMPPLUGIN_COPYRIGHT,	// pszCopyright
		KMPPLUGIN_DESCRIPTION,	// pszDescription
		ppszSupportExts,		// ppszSupportExts
		1,						// dwReentrant
		NULL,					// Init
		NULL,					// Deinit
		kmp_Open,				// Open
		NULL,					// OpenFromBuffer
		kmp_Close,				// Close
		kmp_Render,				// Render
		kmp_SetPosition			// SetPosition
	};

	return &Mod;
}

BOOL APIENTRY DllMain(HMODULE hModule,
					  DWORD  ul_reason_for_call,
					  LPVOID lpReserved
					  )
{
	switch (ul_reason_for_call) {
	case DLL_PROCESS_ATTACH:
		DisableThreadLibraryCalls(hModule);
		hKbMucomModule = hModule;
		break;
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}
